	function [Zodd, Podd, Zeven, Peven] = SORT_LATTICE_POLES_BP_Z(P)
	
	% 	Sorts the poles and zeros of a digital lowpass filter into poles 
	%	and zeros for upper and lower branches in a lattice filter according
	%	to section 12.2.1.  
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, Beginning of WWI + 100
	% 	Modified by: 	LW 2014-12-30
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	N = length(P);	
	% BP or BS cases
	P = cplxpair(P);
	A = [atan(imag(P)./real(P)); P]';
	Peven = cplxpair([A(1:4:end,2); A(2:4:end,2)]);
	Podd = cplxpair([A(3:4:end,2); A(4:4:end,2)]);
	Zodd = 1./Podd;
	Zeven = 1./Peven;	
	
